# POS System Deployment Guide
# ===========================

## Server Requirements
- PHP 8.1 or higher
- MySQL 5.7+ or MariaDB 10.3+
- Apache/Nginx web server
- Composer
- Node.js & NPM (for asset compilation)

## PHP Extensions Required
- pdo_mysql
- mbstring
- xml
- curl
- zip
- gd
- bcmath
- json
- fileinfo

## Installation Steps

1. Upload the zip file to your server
2. Extract to your web directory
3. Run: composer install --no-dev --optimize-autoloader
4. Copy .env.example to .env and configure your settings
5. Run: php artisan key:generate
6. Configure your database in .env
7. Run: php artisan migrate --seed
8. Run: php artisan storage:link
9. Run: npm install && npm run build
10. Set proper permissions:
    - chmod -R 755 storage/
    - chmod -R 755 bootstrap/cache/
    - chown -R www-data:www-data /path/to/your/app

## Production Optimizations
- APP_ENV=production
- APP_DEBUG=false
- php artisan config:cache
- php artisan route:cache
- php artisan view:cache

## Cron Jobs (optional)
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1

## Queue Worker (if using queues)
php artisan queue:work --sleep=3 --tries=3 --max-jobs=1000

## Security Notes
- Change default database credentials
- Set strong APP_KEY
- Configure proper file permissions
- Use HTTPS in production
- Regular backup of database and files